/*
 * Decompiled with CFR 0.152.
 */
package org.jeewx.api.ai;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;
import org.jeewx.api.ai.model.Voice;
import org.jeewx.api.cloud.baidu.BaiduCloudService;
import org.jeewx.api.core.util.WeiXinConstant;

public class JwAIApi {
    public static final String ADD_VOICE_URL = "http://api.weixin.qq.com/cgi-bin/media/voice/addvoicetorecofortext?";
    public static final String VOICE_RESULT_URL = "http://api.weixin.qq.com/cgi-bin/media/voice/queryrecoresultfortext?";
    public static final String TRANSLATE_TEXT_URL = "http://api.weixin.qq.com/cgi-bin/media/voice/translatecontent?";
    private static Logger logger = Logger.getLogger(BaiduCloudService.class);

    public static String translateVoice(Voice voice) {
        JSONObject json = JwAIApi.uploadVoice(voice);
        if (json != null && json.containsKey((Object)"errcode") && "0".equals(json.getString("errcode"))) {
            try {
                Thread.sleep(voice.getWaitMill());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return JwAIApi.getVoiceResult(voice.getAccessToken(), voice.getVoice_id(), voice.getLang());
        }
        return null;
    }

    public static String translateText(String accessToken, String lfrom, String lto, String text) {
        String result = null;
        String requestUrl = "http://api.weixin.qq.com/cgi-bin/media/voice/translatecontent?access_token=" + accessToken + "&lfrom=" + lfrom + "&lto=" + lto;
        logger.info((Object)("------\u5fae\u4fe1\u7ffb\u8bd1\u5730\u5740----" + requestUrl));
        logger.info((Object)("------\u5fae\u4fe1\u7ffb\u8bd1\u539f\u6587----" + text));
        JSONObject obj = JwAIApi.httpRequest(requestUrl, "POST", text);
        if (obj != null && obj.containsKey((Object)"to_content")) {
            result = obj.getString("to_content");
        }
        logger.info((Object)("------\u5fae\u4fe1\u7ffb\u8bd1\u7ed3\u679c----" + result));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSONObject uploadVoice(Voice voice) {
        JSONObject jsonobject = new JSONObject();
        String result = null;
        File file = new File(voice.getFile());
        if (!file.exists() || !file.isFile()) {
            jsonobject = null;
            logger.info((Object)"--\u63d0\u4ea4\u8bed\u97f3\u63a5\u53e3\uff0c\u6587\u4ef6\u4e0d\u5b58\u5728------");
        } else {
            HttpURLConnection con = null;
            OutputStream out = null;
            FilterInputStream in = null;
            String requestUrl = voice.getReqestUrl(ADD_VOICE_URL);
            logger.info((Object)("--\u63d0\u4ea4\u8bed\u97f3\u63a5\u53e3\u8bf7\u6c42\uff1a" + requestUrl));
            try {
                URL urlObj = new URL(requestUrl);
                con = (HttpURLConnection)urlObj.openConnection();
                con.setRequestMethod("POST");
                con.setDoInput(true);
                con.setDoOutput(true);
                con.setUseCaches(false);
                con.setConnectTimeout(8000);
                con.setReadTimeout(8000);
                con.setRequestProperty("Connection", "Keep-Alive");
                con.setRequestProperty("Charset", "UTF-8");
                String BOUNDARY = "----------" + System.currentTimeMillis();
                con.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);
                StringBuilder sb = new StringBuilder();
                sb.append("--");
                sb.append(BOUNDARY);
                sb.append("\r\n");
                sb.append("Content-Disposition: form-data;name=\"media\";filelength=\"" + file.length() + "\";filename=\"" + file.getName() + "\"\r\n");
                sb.append("Content-Type:application/octet-stream\r\n\r\n");
                byte[] head = sb.toString().getBytes("utf-8");
                out = new DataOutputStream(con.getOutputStream());
                out.write(head);
                in = new DataInputStream(new FileInputStream(file));
                int bytes = 0;
                byte[] bufferOut = new byte[1024];
                while ((bytes = ((DataInputStream)in).read(bufferOut)) != -1) {
                    out.write(bufferOut, 0, bytes);
                }
                in.close();
                byte[] foot = ("\r\n--" + BOUNDARY + "--\r\n").getBytes("utf-8");
                out.write(foot);
                out.flush();
                out.close();
                StringBuffer buffer = new StringBuffer();
                try (BufferedReader reader = null;){
                    reader = new BufferedReader(new InputStreamReader(con.getInputStream()));
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        buffer.append(line);
                    }
                    if (result == null) {
                        result = buffer.toString();
                    }
                    logger.info((Object)("--\u63d0\u4ea4\u8bed\u97f3\u63a5\u53e3\u8fd4\u56de\uff1a" + buffer.toString()));
                }
                jsonobject = JSONObject.fromObject(result);
            }
            catch (Exception e) {
                logger.info((Object)e.getMessage());
                e.printStackTrace();
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                    if (con != null) {
                        con.disconnect();
                    }
                }
                catch (Exception e) {}
            }
        }
        return jsonobject;
    }

    private static String getVoiceResult(String accessToken, String voice_id, String lang) {
        lang = lang == null || "".equals(lang) ? "zh_CN" : lang;
        String requestUrl = "http://api.weixin.qq.com/cgi-bin/media/voice/queryrecoresultfortext?access_token=" + accessToken + "&voice_id=" + voice_id + "&lang=" + lang;
        logger.info((Object)("--\u83b7\u53d6\u8bed\u97f3\u8bc6\u522b\u7ed3\u679c\u8bf7\u6c42\u53c2\u6570\uff1a" + requestUrl));
        JSONObject result = JwAIApi.httpRequest(requestUrl, "POST", null);
        if (result != null) {
            logger.info((Object)("--\u83b7\u53d6\u8bed\u97f3\u8bc6\u522b\u7ed3\u679c---" + result));
        } else {
            logger.info((Object)"--\u83b7\u53d6\u8bed\u97f3\u8bc6\u522b\u7ed3\u679c\u4e3a\u7a7a---");
        }
        Object error = result.get(WeiXinConstant.RETURN_ERROR_INFO_CODE);
        if (error == null) {
            return result.getString("result");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSONObject httpRequest(String requestUrl, String requestMethod, String outputStr) {
        JSONObject jsonObject = null;
        StringBuffer buffer = new StringBuffer();
        HttpURLConnection httpUrlConn = null;
        try {
            URL url = new URL(requestUrl);
            httpUrlConn = (HttpURLConnection)url.openConnection();
            httpUrlConn.setDoOutput(true);
            httpUrlConn.setDoInput(true);
            httpUrlConn.setUseCaches(false);
            httpUrlConn.setConnectTimeout(500000);
            httpUrlConn.setRequestMethod(requestMethod);
            if ("GET".equalsIgnoreCase(requestMethod)) {
                httpUrlConn.connect();
            }
            if (null != outputStr) {
                OutputStream outputStream = httpUrlConn.getOutputStream();
                outputStream.write(outputStr.getBytes("UTF-8"));
                outputStream.close();
            }
            InputStream inputStream = httpUrlConn.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "utf-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String str = null;
            while ((str = bufferedReader.readLine()) != null) {
                buffer.append(str);
            }
            bufferedReader.close();
            inputStreamReader.close();
            inputStream.close();
            inputStream = null;
            httpUrlConn.disconnect();
            logger.info((Object)buffer.toString());
            jsonObject = JSONObject.fromObject((Object)buffer.toString());
        }
        catch (ConnectException ce) {
            ce.printStackTrace();
            logger.info((Object)"Weixin server connection timed out.");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info((Object)("https request error:{}" + e.getMessage()));
        }
        finally {
            try {
                httpUrlConn.disconnect();
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.info((Object)("http close error:{}" + e.getMessage()));
            }
        }
        return jsonObject;
    }

    public static void main(String[] args) {
        String file = "D:\\taoyan\\temp\\wavecn\\abc.mp3";
        String accessToken = "7_VtDvFo4inD4pjPQdwftlMq9Bvj6mIw36gNRQPQFoencaE5oFu_7edpYdXojRvJPI9Nak1cCm5PgG5bLfoazkms81K-ri69QNr_a5AMGqH-sN3cmXQQRbb6ZBk7bGklo2j4OVH4oSBG3O8vvdIKJlCGADFE";
        String voice_id = "ceshi1230981fr4";
        String lang = "zh_CN";
        Voice voice = new Voice(accessToken, "mp3", voice_id, lang, file);
        String voiceContent = JwAIApi.translateVoice(voice);
        System.out.println(voiceContent);
        String lfrom = "zh_CN";
        String lto = "en_US";
        String text = "\u6211\u662f\u4e2d\u56fd\u4eba\u554a";
        JwAIApi.translateText(accessToken, lfrom, lto, text);
    }
}

