/*
 * Decompiled with CFR 0.152.
 */
package org.jeewx.api.core.common;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class HttpPostUtil {
    URL url;
    HttpURLConnection conn;
    String boundary = "--------httppost123";
    Map<String, String> textParams = new HashMap<String, String>();
    Map<String, File> fileparams = new HashMap<String, File>();
    DataOutputStream ds;
    public static final String IMG_JPG = ".jpg";
    public static final String IMG_PNG = ".png";
    public static final String IMG_GIF = ".gif";
    public static final String IMG_BMP = ".bmp";

    public HttpPostUtil(String url) throws Exception {
        this.url = new URL(url);
    }

    public void setUrl(String url) throws Exception {
        this.url = new URL(url);
    }

    public void addTextParameter(String name, String value) {
        this.textParams.put(name, value);
    }

    public void addFileParameter(String name, File value) {
        this.fileparams.put(name, value);
    }

    public void clearAllParameters() {
        this.textParams.clear();
        this.fileparams.clear();
    }

    public byte[] send() throws Exception {
        int b;
        this.initConnection();
        try {
            this.conn.connect();
        }
        catch (SocketTimeoutException e) {
            throw new RuntimeException();
        }
        this.ds = new DataOutputStream(this.conn.getOutputStream());
        this.writeFileParams();
        this.writeStringParams();
        this.paramsEnd();
        InputStream in = this.conn.getInputStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((b = in.read()) != -1) {
            out.write(b);
        }
        this.conn.disconnect();
        return out.toByteArray();
    }

    private void initConnection() throws Exception {
        this.conn = (HttpURLConnection)this.url.openConnection();
        this.conn.setDoOutput(true);
        this.conn.setUseCaches(false);
        this.conn.setConnectTimeout(10000);
        this.conn.setRequestMethod("POST");
        this.conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
    }

    private void writeStringParams() throws Exception {
        Set<String> keySet = this.textParams.keySet();
        for (String name : keySet) {
            String value = this.textParams.get(name);
            this.ds.writeBytes("--" + this.boundary + "\r\n");
            this.ds.writeBytes("Content-Disposition: form-data; name=\"" + name + "\"\r\n");
            this.ds.writeBytes("\r\n");
            this.ds.writeBytes(this.encode(value) + "\r\n");
        }
    }

    private void writeFileParams() throws Exception {
        Set<String> keySet = this.fileparams.keySet();
        for (String name : keySet) {
            File value = this.fileparams.get(name);
            String valuename = value.getName();
            if (value.exists()) {
                this.ds.writeBytes("--" + this.boundary + "\r\n");
                this.ds.writeBytes("Content-Disposition: form-data; name=\"" + name + "\"; filename=\"" + this.encode(valuename) + "\"\r\n");
                this.ds.writeBytes("Content-Type: " + this.getContentType(value) + "\r\n");
                this.ds.writeBytes("\r\n");
                this.ds.write(this.getBytes(value));
            } else {
                String myFilePath = value.getPath();
                if (myFilePath != null && myFilePath.startsWith("http")) {
                    byte[] netFileBytes = this.getURIFileBytes(myFilePath);
                    String lowerValueName = valuename.toLowerCase();
                    valuename = lowerValueName.endsWith(IMG_BMP) || lowerValueName.endsWith(IMG_GIF) || lowerValueName.endsWith(IMG_JPG) || lowerValueName.endsWith(IMG_PNG) ? this.encode(valuename) : System.currentTimeMillis() + this.getPicType(netFileBytes);
                    this.ds.writeBytes("--" + this.boundary + "\r\n");
                    this.ds.writeBytes("Content-Disposition: form-data; name=\"" + name + "\"; filename=\"" + valuename + "\"\r\n");
                    this.ds.writeBytes("Content-Type: " + this.getContentType(value) + "\r\n");
                    this.ds.writeBytes("\r\n");
                    this.ds.write(netFileBytes);
                }
            }
            this.ds.writeBytes("\r\n");
        }
    }

    private byte[] getURIFileBytes(String url) throws IOException {
        url = url.replace("http:" + File.separator, "http://").replace("\\", "/");
        URL oracle = new URL(url);
        InputStream inStream = oracle.openStream();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len = 0;
        while ((len = inStream.read(buffer)) != -1) {
            outStream.write(buffer, 0, len);
        }
        inStream.close();
        return outStream.toByteArray();
    }

    private String getContentType(File f) throws Exception {
        ImageInputStream imagein = ImageIO.createImageInputStream(f);
        if (imagein == null) {
            return "application/octet-stream";
        }
        Iterator<ImageReader> it = ImageIO.getImageReaders(imagein);
        if (!it.hasNext()) {
            imagein.close();
            return "application/octet-stream";
        }
        imagein.close();
        return "image/" + it.next().getFormatName().toLowerCase();
    }

    private byte[] getBytes(File f) throws Exception {
        int n;
        FileInputStream in = new FileInputStream(f);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] b = new byte[1024];
        while ((n = in.read(b)) != -1) {
            out.write(b, 0, n);
        }
        in.close();
        return out.toByteArray();
    }

    private void paramsEnd() throws Exception {
        this.ds.writeBytes("--" + this.boundary + "--" + "\r\n");
        this.ds.writeBytes("\r\n");
    }

    private String encode(String value) throws Exception {
        return URLEncoder.encode(value, "UTF-8");
    }

    public String getPicType(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder();
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < 4; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        String type = stringBuilder.toString().toUpperCase();
        if (type.contains("FFD8FF")) {
            return IMG_JPG;
        }
        if (type.contains("89504E47")) {
            return IMG_PNG;
        }
        if (type.contains("47494638")) {
            return IMG_GIF;
        }
        if (type.contains("424D")) {
            return IMG_BMP;
        }
        return "";
    }

    public static void main(String[] args) throws Exception {
        HttpPostUtil u = new HttpPostUtil("https://api.weixin.qq.com/cgi-bin/media/uploadimg?access_token=i3um002Np_n-mgNVbPP9JEIfft7_hRq3eHE86slxI7Uh_5q0K5rFfLRnhD20HTCcFt92ulWnndpGlyiNgXi6UiWQqKxPCBsfYKmiY6Ws-isUVLaAFAXYO");
        u.addFileParameter("img", new File("C:/Users/zhangdaihao/Desktop/2.png"));
        byte[] b = u.send();
        String result = new String(b);
        System.out.println(result);
    }
}

