/*
 * Decompiled with CFR 0.152.
 */
package org.jeewx.api.core.handler.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.jeewx.api.core.annotation.ReqType;
import org.jeewx.api.core.exception.WexinReqException;
import org.jeewx.api.core.handler.WeiXinReqHandler;
import org.jeewx.api.core.req.model.WeixinReqConfig;
import org.jeewx.api.core.req.model.WeixinReqParam;
import org.jeewx.api.core.req.model.menu.MenuCreate;
import org.jeewx.api.core.req.model.menu.WeixinButton;
import org.jeewx.api.core.util.HttpRequestProxy;
import org.jeewx.api.core.util.WeiXinReqUtil;

public class WeixinReqMenuCreateHandler
implements WeiXinReqHandler {
    private static Logger logger = Logger.getLogger(WeixinReqMenuCreateHandler.class);

    @Override
    public String doRequest(WeixinReqParam weixinReqParam) throws WexinReqException {
        String strReturnInfo = "";
        if (weixinReqParam.getClass().isAnnotationPresent(ReqType.class)) {
            ReqType reqType = weixinReqParam.getClass().getAnnotation(ReqType.class);
            WeixinReqConfig objConfig = WeiXinReqUtil.getWeixinReqConfig(reqType.value());
            if (objConfig != null) {
                String reqUrl = objConfig.getUrl();
                MenuCreate mc = (MenuCreate)weixinReqParam;
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("access_token", mc.getAccess_token());
                String jsonData = "{" + this.getMenuButtonJson("button", mc.getButton()) + "}";
                logger.info((Object)("\u5904\u7406\u521b\u5efa\u83dc\u5355" + jsonData));
                strReturnInfo = HttpRequestProxy.doJsonPost(reqUrl, parameters, jsonData);
            }
        } else {
            logger.info((Object)"\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u914d\u7f6e\u4fe1\u606f");
        }
        return strReturnInfo;
    }

    private String getMenuButtonJson(String name, List<WeixinButton> b) {
        StringBuffer json = new StringBuffer();
        json.append("\"" + name + "\":[");
        if (b == null || b.size() == 0) {
            return json.append("]").toString();
        }
        List<WeixinButton> sub_button = null;
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        String objJson = "";
        for (WeixinButton m : b) {
            sub_button = m.getSub_button();
            m.setSub_button(null);
            objJson = gson.toJson((Object)m);
            json.append(objJson);
            if (sub_button != null && sub_button.size() > 0) {
                json.setLength(json.length() - 1);
                json.append(",");
                objJson = this.getMenuButtonJson("sub_button", sub_button);
                json.append(objJson);
                json.append("}");
            }
            m.setSub_button(sub_button);
            json.append(",");
        }
        json.setLength(json.length() - 1);
        json.append("]");
        return json.toString();
    }
}

