/*
 * Decompiled with CFR 0.152.
 */
package org.jeewx.api.wxsendmsg;

import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import net.sf.json.JSONObject;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jeewx.api.core.common.HttpPostUtil;
import org.jeewx.api.core.common.WxstoreUtils;
import org.jeewx.api.core.exception.WexinReqException;
import org.jeewx.api.core.req.model.user.Group;
import org.jeewx.api.core.util.WeiXinReqUtil;
import org.jeewx.api.wxbase.wxmedia.model.WxArticlesRequest;
import org.jeewx.api.wxsendmsg.model.SendMessageReport;
import org.jeewx.api.wxsendmsg.model.SendMessageResponse;
import org.jeewx.api.wxsendmsg.model.WxArticle;
import org.jeewx.api.wxsendmsg.model.WxArticlesResponse;
import org.jeewx.api.wxsendmsg.model.WxMedia;
import org.jeewx.api.wxsendmsg.model.WxMediaResponse;
import org.jeewx.api.wxsendmsg.util.ReadImgUrls;
import org.jeewx.api.wxuser.user.model.Wxuser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwSendMessageAPI {
    private static Logger logger = LoggerFactory.getLogger(JwSendMessageAPI.class);
    private static String message_preview_url = "https://api.weixin.qq.com/cgi-bin/message/mass/preview?access_token=ACCESS_TOKEN";
    private static String upload_media_url = "http://file.api.weixin.qq.com/cgi-bin/media/upload?access_token=ACCESS_TOKEN&type=TYPE";
    private static String upload_article_url = "https://api.weixin.qq.com/cgi-bin/media/uploadnews?access_token=ACCESS_TOKEN";
    private static String message_group_url = "https://api.weixin.qq.com/cgi-bin/message/mass/sendall?access_token=ACCESS_TOKEN";
    private static String message_openid_url = "https://api.weixin.qq.com/cgi-bin/message/mass/send?access_token=ACCESS_TOKEN";
    private static String message_delete_url = "https://api.weixin.qq.com/cgi-bin/message/mass/delete?access_token=ACCESS_TOKEN";
    private static String message_get_url = "https://api.weixin.qq.com/cgi-bin/message/mass/get?access_token=ACCESS_TOKEN";
    private static String uploadimg_url = "https://api.weixin.qq.com/cgi-bin/media/uploadimg?access_token=ACCESS_TOKEN";

    public static String uploadArticleImgs(String content, String accesstoken, String baseImageUrl, String domain) {
        try {
            String[] urls;
            for (String imgurl : urls = ReadImgUrls.getImgs(content)) {
                if (imgurl.indexOf("mmbiz.qpic.cn") != -1) continue;
                String tempimgurl = imgurl;
                tempimgurl = tempimgurl.replace(domain, "");
                tempimgurl = baseImageUrl + tempimgurl;
                String newUrl = JwSendMessageAPI.uploadImg(accesstoken, tempimgurl);
                content = content.replace(imgurl, newUrl);
            }
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
        return content;
    }

    public static String uploadImg(String accesstoken, String filePath) {
        try {
            if (accesstoken != null) {
                String requestUrl = uploadimg_url.replace("ACCESS_TOKEN", accesstoken);
                HttpPostUtil u = new HttpPostUtil(requestUrl);
                u.addFileParameter("img", new File(filePath));
                JSONObject result = JSONObject.fromObject((Object)new String(u.send()));
                if (result != null) {
                    if (result.containsKey((Object)"url")) {
                        return result.getString("url");
                    }
                    System.err.println(result.toString());
                }
            }
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
        return "";
    }

    public static JSONObject uploadImgReturnObj(String accesstoken, String filePath) {
        JSONObject result = new JSONObject();
        try {
            if (accesstoken != null) {
                String requestUrl = uploadimg_url.replace("ACCESS_TOKEN", accesstoken);
                HttpPostUtil u = new HttpPostUtil(requestUrl);
                u.addFileParameter("img", new File(filePath));
                result = JSONObject.fromObject((Object)new String(u.send()));
                if (result != null && !result.containsKey((Object)"url")) {
                    System.err.println(result.toString());
                }
            }
        }
        catch (Exception e) {
            result.put((Object)"errmsg", (Object)e.toString());
            result.put((Object)"errcode", (Object)"");
            System.err.println(e.toString());
        }
        return result;
    }

    public static void messagePrivate(String accesstoken, String touser, List<WxArticle> wxArticles) throws WexinReqException {
        if (accesstoken != null) {
            String requestUrl = message_preview_url.replace("ACCESS_TOKEN", accesstoken);
            try {
                String mediaId = JwSendMessageAPI.getMediaId(accesstoken, wxArticles);
                JSONObject obj = new JSONObject();
                JSONObject mpnews = new JSONObject();
                obj.put((Object)"touser", (Object)touser);
                obj.put((Object)"msgtype", (Object)"mpnews");
                mpnews.put((Object)"media_id", (Object)mediaId);
                obj.put((Object)"mpnews", (Object)mpnews);
                JSONObject result = WxstoreUtils.httpRequest(requestUrl, "POST", obj.toString());
            }
            catch (Exception e) {
                throw new WexinReqException(e);
            }
        } else {
            throw new WexinReqException("accesstoken \u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
    }

    public static String messagePrivate(String accesstoken, String touser, String content) throws WexinReqException {
        String ret = "";
        if (accesstoken != null) {
            String requestUrl = message_preview_url.replace("ACCESS_TOKEN", accesstoken);
            try {
                JSONObject obj = new JSONObject();
                JSONObject text = new JSONObject();
                obj.put((Object)"touser", (Object)touser);
                obj.put((Object)"msgtype", (Object)"text");
                text.put((Object)"content", (Object)content);
                obj.put((Object)"text", (Object)text);
                JSONObject result = WxstoreUtils.httpRequest(requestUrl, "POST", obj.toString());
                ret = result.toString();
            }
            catch (Exception e) {
                throw new WexinReqException(e);
            }
        } else {
            throw new WexinReqException("accesstoken \u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        return ret;
    }

    public static void messagePrivate(String accesstoken, String touser, WxMedia wxMedia) throws WexinReqException {
        block4: {
            if (accesstoken != null) {
                String requestUrl = message_preview_url.replace("ACCESS_TOKEN", accesstoken);
                try {
                    String mediaId = JwSendMessageAPI.getMediaId(accesstoken, wxMedia);
                    JSONObject obj = new JSONObject();
                    JSONObject type = new JSONObject();
                    obj.put((Object)"touser", (Object)touser);
                    obj.put((Object)"msgtype", (Object)wxMedia.getType());
                    type.put((Object)"media_id", (Object)mediaId);
                    obj.put((Object)wxMedia.getType(), (Object)type);
                    JSONObject result = WxstoreUtils.httpRequest(requestUrl, "POST", obj.toString());
                    if (result.getInt("errcode") != 0) {
                        logger.error("\u591a\u5a92\u4f53\u6d88\u606f\u9884\u89c8\u5931\u8d25\uff01errcode=" + result.getString("errcode") + ",errmsg = " + result.getString("errmsg"));
                        throw new Exception("\u591a\u5a92\u4f53\u6d88\u606f\u9884\u89c8\u5931\u8d25\uff01errcode=" + result.getString("errcode") + ",errmsg = " + result.getString("errmsg"));
                    }
                    break block4;
                }
                catch (Exception e) {
                    throw new WexinReqException(e);
                }
            }
            throw new WexinReqException("accesstoken \u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
    }

    public static SendMessageResponse sendMessageToGroupOrAllWithArticles(String accesstoken, boolean is_to_all, Group group, List<WxArticle> wxArticles) throws WexinReqException {
        SendMessageResponse response = null;
        if (accesstoken != null) {
            String requestUrl = message_group_url.replace("ACCESS_TOKEN", accesstoken);
            try {
                String mediaId = JwSendMessageAPI.getMediaId(accesstoken, wxArticles);
                JSONObject obj = new JSONObject();
                JSONObject filter = new JSONObject();
                JSONObject mpnews = new JSONObject();
                filter.put((Object)"is_to_all", (Object)is_to_all);
                if (!is_to_all) {
                    filter.put((Object)"group_id", (Object)group.getId());
                }
                obj.put((Object)"filter", (Object)filter);
                mpnews.put((Object)"media_id", (Object)mediaId);
                obj.put((Object)"mpnews", (Object)mpnews);
                obj.put((Object)"msgtype", (Object)"mpnews");
                JSONObject result = WxstoreUtils.httpRequest(requestUrl, "POST", obj.toString());
                response = (SendMessageResponse)JSONObject.toBean((JSONObject)result, SendMessageResponse.class);
            }
            catch (Exception e) {
                throw new WexinReqException(e);
            }
        } else {
            throw new WexinReqException("accesstoken \u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        return response;
    }

    public static SendMessageResponse sendMessageToGroupOrAllWithText(String accesstoken, boolean is_to_all, Group group, String content) throws WexinReqException {
        SendMessageResponse response = null;
        if (accesstoken != null) {
            String requestUrl = message_group_url.replace("ACCESS_TOKEN", accesstoken);
            try {
                JSONObject obj = new JSONObject();
                JSONObject filter = new JSONObject();
                JSONObject text = new JSONObject();
                filter.put((Object)"is_to_all", (Object)is_to_all);
                if (!is_to_all) {
                    filter.put((Object)"group_id", (Object)group.getId());
                }
                obj.put((Object)"filter", (Object)filter);
                text.put((Object)"content", (Object)content);
                obj.put((Object)"text", (Object)text);
                obj.put((Object)"msgtype", (Object)"text");
                JSONObject result = WxstoreUtils.httpRequest(requestUrl, "POST", obj.toString());
                response = (SendMessageResponse)JSONObject.toBean((JSONObject)result, SendMessageResponse.class);
            }
            catch (Exception e) {
                throw new WexinReqException(e);
            }
        } else {
            throw new WexinReqException("accesstoken \u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        return response;
    }

    public static SendMessageResponse sendMessageToGroupOrAllWithMedia(String accesstoken, boolean is_to_all, Group group, WxMedia wxMedia) throws WexinReqException {
        SendMessageResponse response = null;
        if (accesstoken != null) {
            String requestUrl = message_group_url.replace("ACCESS_TOKEN", accesstoken);
            try {
                String mediaId = JwSendMessageAPI.getMediaId(accesstoken, wxMedia);
                JSONObject obj = new JSONObject();
                JSONObject filter = new JSONObject();
                JSONObject media = new JSONObject();
                filter.put((Object)"is_to_all", (Object)is_to_all);
                if (!is_to_all) {
                    filter.put((Object)"group_id", (Object)group.getId());
                }
                obj.put((Object)"filter", (Object)filter);
                media.put((Object)"media_id", (Object)mediaId);
                obj.put((Object)wxMedia.getType(), (Object)media);
                obj.put((Object)"msgtype", (Object)wxMedia.getType());
                JSONObject result = WxstoreUtils.httpRequest(requestUrl, "POST", obj.toString());
                response = (SendMessageResponse)JSONObject.toBean((JSONObject)result, SendMessageResponse.class);
            }
            catch (Exception e) {
                throw new WexinReqException(e);
            }
        } else {
            throw new WexinReqException("accesstoken \u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        return response;
    }

    public static SendMessageResponse sendMessageToOpenidsWithArticles(String accesstoken, Wxuser[] wxusers, List<WxArticle> wxArticles) throws WexinReqException {
        SendMessageResponse response = null;
        if (accesstoken != null) {
            String requestUrl = message_openid_url.replace("ACCESS_TOKEN", accesstoken);
            ArrayList<String> openids = new ArrayList<String>();
            for (Wxuser wxuser : wxusers) {
                openids.add(wxuser.getOpenid());
            }
            try {
                String mediaId = JwSendMessageAPI.getMediaId(accesstoken, wxArticles);
                JSONObject obj = new JSONObject();
                JSONObject mpnews = new JSONObject();
                obj.put((Object)"touser", openids);
                mpnews.put((Object)"media_id", (Object)mediaId);
                obj.put((Object)"mpnews", (Object)mpnews);
                obj.put((Object)"msgtype", (Object)"mpnews");
                JSONObject result = WxstoreUtils.httpRequest(requestUrl, "POST", obj.toString());
                response = (SendMessageResponse)JSONObject.toBean((JSONObject)result, SendMessageResponse.class);
            }
            catch (Exception e) {
                throw new WexinReqException(e);
            }
        } else {
            throw new WexinReqException("accesstoken \u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        return response;
    }

    public static SendMessageResponse sendMessageToOpenidsWithText(String accesstoken, Wxuser[] wxusers, String content) throws WexinReqException {
        SendMessageResponse response = null;
        if (accesstoken != null) {
            String requestUrl = message_openid_url.replace("ACCESS_TOKEN", accesstoken);
            ArrayList<String> openids = new ArrayList<String>();
            for (Wxuser wxuser : wxusers) {
                openids.add(wxuser.getOpenid());
            }
            try {
                JSONObject obj = new JSONObject();
                JSONObject text = new JSONObject();
                obj.put((Object)"touser", openids);
                text.put((Object)"content", (Object)content);
                obj.put((Object)"text", (Object)text);
                obj.put((Object)"msgtype", (Object)"text");
                JSONObject result = WxstoreUtils.httpRequest(requestUrl, "POST", obj.toString());
                response = (SendMessageResponse)JSONObject.toBean((JSONObject)result, SendMessageResponse.class);
            }
            catch (Exception e) {
                throw new WexinReqException(e);
            }
        } else {
            throw new WexinReqException("accesstoken \u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        return response;
    }

    public static SendMessageResponse sendMessageToOpenidsWithMedia(String accesstoken, Wxuser[] wxusers, WxMedia wxMedia) throws WexinReqException {
        SendMessageResponse response = null;
        if (accesstoken != null) {
            String requestUrl = message_openid_url.replace("ACCESS_TOKEN", accesstoken);
            ArrayList<String> openids = new ArrayList<String>();
            for (Wxuser wxuser : wxusers) {
                openids.add(wxuser.getOpenid());
            }
            try {
                String mediaId = JwSendMessageAPI.getMediaId(accesstoken, wxMedia);
                JSONObject obj = new JSONObject();
                JSONObject media = new JSONObject();
                obj.put((Object)"touser", openids);
                media.put((Object)"media_id", (Object)mediaId);
                obj.put((Object)wxMedia.getType(), (Object)media);
                obj.put((Object)"msgtype", (Object)wxMedia.getType());
                JSONObject result = WxstoreUtils.httpRequest(requestUrl, "POST", obj.toString());
                response = (SendMessageResponse)JSONObject.toBean((JSONObject)result, SendMessageResponse.class);
            }
            catch (Exception e) {
                throw new WexinReqException(e);
            }
        } else {
            throw new WexinReqException("accesstoken \u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        return response;
    }

    public static String deleteSendMessage(String accesstoken, String msg_id) throws WexinReqException {
        String response = null;
        if (accesstoken != null) {
            String requestUrl = message_delete_url.replace("ACCESS_TOKEN", accesstoken);
            try {
                JSONObject obj = new JSONObject();
                obj.put((Object)"msg_id", (Object)msg_id);
                JSONObject result = WxstoreUtils.httpRequest(requestUrl, "POST", obj.toString());
                response = result.toString();
            }
            catch (Exception e) {
                throw new WexinReqException(e);
            }
        } else {
            throw new WexinReqException("accesstoken \u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        return response;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean getSendMessageStatus(String accesstoken, String msg_id) throws WexinReqException {
        boolean response = false;
        if (accesstoken == null) throw new WexinReqException("accesstoken \u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        String requestUrl = message_get_url.replace("ACCESS_TOKEN", accesstoken);
        try {
            JSONObject obj = new JSONObject();
            obj.put((Object)"msg_id", (Object)msg_id);
            JSONObject result = WxstoreUtils.httpRequest(requestUrl, "POST", obj.toString());
            if (!result.containsKey((Object)"msg_status")) return response;
            if (!"SEND_SUCCESS".equalsIgnoreCase(result.getString("msg_status"))) return response;
            return true;
        }
        catch (Exception e) {
            throw new WexinReqException(e);
        }
    }

    public static SendMessageReport getReportBySendMessageReturnString(String xmlString) throws WexinReqException {
        SendMessageReport report = new SendMessageReport();
        SAXBuilder build = new SAXBuilder();
        Document doc = null;
        try {
            doc = build.build((Reader)new StringReader(xmlString));
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw new WexinReqException(e1);
        }
        Element root = doc.getRootElement();
        Iterator itr = root.getChildren().iterator();
        Class<SendMessageReport> clazz = SendMessageReport.class;
        while (itr.hasNext()) {
            Element oneLevelDeep = (Element)itr.next();
            try {
                Field filed = clazz.getDeclaredField(oneLevelDeep.getName());
                filed.setAccessible(true);
                filed.set(report, oneLevelDeep.getText());
                filed.setAccessible(false);
            }
            catch (NoSuchFieldException e) {
            }
            catch (SecurityException e) {
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {}
        }
        return report;
    }

    public static String getMediaId(String accesstoken, WxMedia wxMedia) throws WexinReqException {
        WxMediaResponse response = JwSendMessageAPI.uploadMediaFile(accesstoken, wxMedia.getFilePath(), wxMedia.getFileName(), wxMedia.getType());
        if (response == null) {
            throw new WexinReqException("\u83b7\u53d6\u591a\u5a92\u4f53\u8d44\u6e90\u7684mediaId\u5931\u8d25");
        }
        return response.getMedia_id();
    }

    public static String getMediaId(String accesstoken, List<WxArticle> wxArticles) throws WexinReqException {
        WxArticlesResponse response = JwSendMessageAPI.uploadArticles(accesstoken, wxArticles);
        if (response == null) {
            throw new WexinReqException("\u83b7\u53d6\u56fe\u6587\u7684mediaId\u5931\u8d25");
        }
        return response.getMedia_id();
    }

    public static WxArticlesResponse uploadArticles(String accesstoken, List<WxArticle> wxArticles) throws WexinReqException {
        WxArticlesResponse wxArticlesResponse = null;
        if (wxArticles.size() == 0) {
            logger.error("\u6ca1\u6709\u4e0a\u4f20\u7684\u56fe\u6587\u6d88\u606f");
        } else if (wxArticles.size() > 10) {
            logger.error("\u56fe\u6587\u6d88\u606f\u6700\u591a\u4e3a10\u4e2a\u56fe\u6587");
        } else if (accesstoken != null) {
            String requestUrl = upload_article_url.replace("ACCESS_TOKEN", accesstoken);
            for (WxArticle article : wxArticles) {
                if (article.getFileName() == null || article.getFileName().length() <= 0) continue;
                try {
                    String mediaId = JwSendMessageAPI.getFileMediaId(accesstoken, article);
                    article.setThumb_media_id(mediaId);
                }
                catch (Exception e) {
                    throw new WexinReqException(e);
                }
            }
            WxArticlesRequest wxArticlesRequest = new WxArticlesRequest();
            wxArticlesRequest.setArticles(wxArticles);
            JSONObject obj = JSONObject.fromObject((Object)wxArticlesRequest);
            JSONObject result = WxstoreUtils.httpRequest(requestUrl, "POST", obj.toString());
            if (result.has("errcode")) {
                logger.error("\u4e0a\u4f20\u56fe\u6587\u6d88\u606f\u5931\u8d25\uff01errcode=" + result.getString("errcode") + ",errmsg = " + result.getString("errmsg"));
                throw new WexinReqException("\u4e0a\u4f20\u56fe\u6587\u6d88\u606f\u5931\u8d25\uff01errcode=" + result.getString("errcode") + ",errmsg = " + result.getString("errmsg"));
            }
            wxArticlesResponse = new WxArticlesResponse();
            wxArticlesResponse.setMedia_id(result.getString("media_id"));
            wxArticlesResponse.setType(result.getString("type"));
            wxArticlesResponse.setCreated_at(new Date(result.getLong("created_at") * 1000L));
        }
        return wxArticlesResponse;
    }

    public static String getFileMediaId(String accesstoken, WxArticle article) throws WexinReqException {
        WxMediaResponse response = JwSendMessageAPI.uploadMediaFile(accesstoken, article.getFilePath(), article.getFileName(), "image");
        if (response != null) {
            return response.getMedia_id();
        }
        throw new WexinReqException("\u83b7\u53d6\u6587\u4ef6\u7684media_id\u5931\u8d25");
    }

    public static WxMediaResponse uploadMediaFile(String accesstoken, String filePath, String fileName, String type) throws WexinReqException {
        WxMediaResponse mediaResource = null;
        if (accesstoken != null) {
            String contentType;
            File file;
            String requestUrl = upload_media_url.replace("ACCESS_TOKEN", accesstoken).replace("TYPE", type);
            JSONObject result = WxstoreUtils.uploadMediaFile(requestUrl, file = new File(filePath + fileName), contentType = WeiXinReqUtil.getFileContentType(fileName.substring(fileName.lastIndexOf(".") + 1)));
            if (result.containsKey((Object)"errcode")) {
                logger.error("\u4e0a\u4f20\u5a92\u4f53\u8d44\u6e90\u5931\u8d25\uff01errcode=" + result.getString("errcode") + ",errmsg = " + result.getString("errmsg"));
            } else {
                mediaResource = new WxMediaResponse();
                mediaResource.setMedia_id(result.getString("media_id"));
                mediaResource.setType(result.getString("type"));
                mediaResource.setCreated_at(new Date(result.getLong("created_at") * 1000L));
            }
        }
        return mediaResource;
    }

    public static void main(String[] args) throws WexinReqException {
    }
}

