/*
 * Decompiled with CFR 0.152.
 */
package org.jeewx.api.wxsendmsg.test;

import java.util.ArrayList;
import org.jeewx.api.core.common.AccessToken;
import org.jeewx.api.core.exception.WexinReqException;
import org.jeewx.api.core.req.model.user.Group;
import org.jeewx.api.wxsendmsg.JwSendMessageAPI;
import org.jeewx.api.wxsendmsg.model.SendMessageReport;
import org.jeewx.api.wxsendmsg.model.SendMessageResponse;
import org.jeewx.api.wxsendmsg.model.WxArticle;
import org.jeewx.api.wxsendmsg.model.WxMedia;
import org.jeewx.api.wxuser.user.model.Wxuser;
import org.junit.Before;
import org.junit.Test;

public class JwSendMessageAPITest {
    private static String newAccessToken = null;
    private static String touser = null;
    JwSendMessageAPI service = null;

    @Before
    public void getToken() throws WexinReqException {
        String strtoken;
        this.service = new JwSendMessageAPI();
        touser = "oA1Vct-_r1rAd5mcL3lEZKgcvGZY";
        String appid = "wxb512901288a94943";
        String appscret = "6f94b81b49cf9f89fafe305dcaf2c632";
        AccessToken token = new AccessToken(appid, appscret);
        newAccessToken = strtoken = token.getNewAccessToken();
        System.out.println(strtoken);
    }

    @Test
    public void testMessagePrivateStringStringString() {
        try {
            String r = JwSendMessageAPI.messagePrivate(newAccessToken, touser, "\u6211\u8981\u9884\u89c8\u554a");
            System.out.println(r);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testMessagePrivateStringStringListOfWxArticle() {
        try {
            ArrayList<WxArticle> wxArticles = new ArrayList<WxArticle>();
            for (int i = 0; i < 4; ++i) {
                WxArticle article = new WxArticle();
                article.setAuthor("author" + i);
                article.setContent("Content" + i);
                article.setDigest("Digest" + i);
                article.setShow_cover_pic("1");
                article.setTitle("title" + i);
                article.setFileName("showqrcode.jpg");
                article.setFilePath("F:\\img\\");
                wxArticles.add(article);
            }
            JwSendMessageAPI.messagePrivate(newAccessToken, touser, wxArticles);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testMessagePrivateStringStringWxMedia() {
        WxMedia media = new WxMedia();
        media.setType("image");
        media.setFileName("showqrcode.jpg");
        media.setFilePath("F:\\img\\");
        try {
            JwSendMessageAPI.messagePrivate(newAccessToken, touser, media);
        }
        catch (WexinReqException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testSendMessageToGroupOrAllWithText() {
        try {
            Group group = new Group();
            group.setId("101");
            SendMessageResponse response = JwSendMessageAPI.sendMessageToGroupOrAllWithText(newAccessToken, false, group, "\u6211\u7684\u6587\u672c\u9884\u89c8\u3002\u3002\u3002");
            System.out.println(response);
        }
        catch (WexinReqException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testSendMessageToGroupOrAllWithArticles() {
        try {
            ArrayList<WxArticle> wxArticles = new ArrayList<WxArticle>();
            for (int i = 0; i < 4; ++i) {
                WxArticle article = new WxArticle();
                article.setAuthor("author" + i);
                article.setContent("Content" + i);
                article.setDigest("Digest" + i);
                article.setShow_cover_pic("1");
                article.setTitle("title" + i);
                article.setFileName("showqrcode.jpg");
                article.setFilePath("F:\\img\\");
                wxArticles.add(article);
            }
            Group group = new Group();
            group.setId("101");
            JwSendMessageAPI.sendMessageToGroupOrAllWithArticles(newAccessToken, false, group, wxArticles);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testSendMessageToGroupOrAllWithMedia() {
        WxMedia media = new WxMedia();
        media.setType("image");
        media.setFileName("showqrcode.jpg");
        media.setFilePath("F:\\img\\");
        try {
            Group group = new Group();
            group.setId("101");
            JwSendMessageAPI.sendMessageToGroupOrAllWithMedia(newAccessToken, false, group, media);
        }
        catch (WexinReqException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testSendMessageToOpenidsWithText() {
        try {
            Wxuser user = new Wxuser();
            user.setOpenid(touser);
            Wxuser[] wxusers = new Wxuser[]{user};
            SendMessageResponse response = JwSendMessageAPI.sendMessageToOpenidsWithText(newAccessToken, wxusers, "\u6211\u7684\u6587\u672c\u9884\u89c8\u3002\u3002\u3002");
            System.out.println(response);
        }
        catch (WexinReqException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testSendMessageToOpenidsWithArticles() {
        try {
            ArrayList<WxArticle> wxArticles = new ArrayList<WxArticle>();
            for (int i = 0; i < 4; ++i) {
                WxArticle article = new WxArticle();
                article.setAuthor("author" + i);
                article.setContent("Content" + i);
                article.setDigest("Digest" + i);
                article.setShow_cover_pic("1");
                article.setTitle("title" + i);
                article.setFileName("showqrcode.jpg");
                article.setFilePath("F:\\img\\");
                wxArticles.add(article);
            }
            Wxuser user = new Wxuser();
            user.setOpenid(touser);
            Wxuser[] wxusers = new Wxuser[]{user};
            JwSendMessageAPI.sendMessageToOpenidsWithArticles(newAccessToken, wxusers, wxArticles);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testSendMessageToOpenidsWithMedia() {
        WxMedia media = new WxMedia();
        media.setType("image");
        media.setFileName("showqrcode.jpg");
        media.setFilePath("F:\\img\\");
        try {
            Wxuser user = new Wxuser();
            user.setOpenid(touser);
            Wxuser[] wxusers = new Wxuser[]{user};
            JwSendMessageAPI.sendMessageToOpenidsWithMedia(newAccessToken, wxusers, media);
        }
        catch (WexinReqException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testDeleteSendMessage() {
        try {
            String response = JwSendMessageAPI.deleteSendMessage(newAccessToken, "2350922727");
            System.out.println(response);
        }
        catch (WexinReqException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testGetSendMessageStatus() {
        try {
            boolean response = JwSendMessageAPI.getSendMessageStatus(newAccessToken, "2350922727");
            System.out.println(response);
        }
        catch (WexinReqException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testGetReportBySendMessageReturnString() {
        String a = "<xml><ToUserName><![CDATA[gh_3e8adccde292]]></ToUserName><FromUserName><![CDATA[oR5Gjjl_eiZoUpGozMo7dbBJ362A]]></FromUserName><CreateTime>1394524295</CreateTime><MsgType><![CDATA[event]]></MsgType><Event><![CDATA[MASSSENDJOBFINISH]]></Event><MsgID>1988</MsgID><Status><![CDATA[sendsuccess]]></Status><TotalCount>100</TotalCount><FilterCount>80</FilterCount><SentCount>75</SentCount><ErrorCount>5</ErrorCount></xml>";
        try {
            SendMessageReport response = JwSendMessageAPI.getReportBySendMessageReturnString(a);
            System.out.println(response);
        }
        catch (WexinReqException e) {
            e.printStackTrace();
        }
    }
}

