/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client;

import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.annotations.ThreadSafe;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.CreateViewOptions;
import com.mongodb.reactivestreams.client.ChangeStreamPublisher;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.ListCollectionsPublisher;
import com.mongodb.reactivestreams.client.MongoCollection;
import com.mongodb.reactivestreams.client.Success;
import java.util.List;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.reactivestreams.Publisher;

@ThreadSafe
public interface MongoDatabase {
    public String getName();

    public CodecRegistry getCodecRegistry();

    public ReadPreference getReadPreference();

    public WriteConcern getWriteConcern();

    public ReadConcern getReadConcern();

    public MongoDatabase withCodecRegistry(CodecRegistry var1);

    public MongoDatabase withReadPreference(ReadPreference var1);

    public MongoDatabase withWriteConcern(WriteConcern var1);

    public MongoDatabase withReadConcern(ReadConcern var1);

    public MongoCollection<Document> getCollection(String var1);

    public <TDocument> MongoCollection<TDocument> getCollection(String var1, Class<TDocument> var2);

    public Publisher<Document> runCommand(Bson var1);

    public Publisher<Document> runCommand(Bson var1, ReadPreference var2);

    public <TResult> Publisher<TResult> runCommand(Bson var1, Class<TResult> var2);

    public <TResult> Publisher<TResult> runCommand(Bson var1, ReadPreference var2, Class<TResult> var3);

    public Publisher<Document> runCommand(ClientSession var1, Bson var2);

    public Publisher<Document> runCommand(ClientSession var1, Bson var2, ReadPreference var3);

    public <TResult> Publisher<TResult> runCommand(ClientSession var1, Bson var2, Class<TResult> var3);

    public <TResult> Publisher<TResult> runCommand(ClientSession var1, Bson var2, ReadPreference var3, Class<TResult> var4);

    public Publisher<Success> drop();

    public Publisher<Success> drop(ClientSession var1);

    public Publisher<String> listCollectionNames();

    public Publisher<String> listCollectionNames(ClientSession var1);

    public ListCollectionsPublisher<Document> listCollections();

    public <TResult> ListCollectionsPublisher<TResult> listCollections(Class<TResult> var1);

    public ListCollectionsPublisher<Document> listCollections(ClientSession var1);

    public <TResult> ListCollectionsPublisher<TResult> listCollections(ClientSession var1, Class<TResult> var2);

    public Publisher<Success> createCollection(String var1);

    public Publisher<Success> createCollection(String var1, CreateCollectionOptions var2);

    public Publisher<Success> createCollection(ClientSession var1, String var2);

    public Publisher<Success> createCollection(ClientSession var1, String var2, CreateCollectionOptions var3);

    public Publisher<Success> createView(String var1, String var2, List<? extends Bson> var3);

    public Publisher<Success> createView(String var1, String var2, List<? extends Bson> var3, CreateViewOptions var4);

    public Publisher<Success> createView(ClientSession var1, String var2, String var3, List<? extends Bson> var4);

    public Publisher<Success> createView(ClientSession var1, String var2, String var3, List<? extends Bson> var4, CreateViewOptions var5);

    public ChangeStreamPublisher<Document> watch();

    public <TResult> ChangeStreamPublisher<TResult> watch(Class<TResult> var1);

    public ChangeStreamPublisher<Document> watch(List<? extends Bson> var1);

    public <TResult> ChangeStreamPublisher<TResult> watch(List<? extends Bson> var1, Class<TResult> var2);

    public ChangeStreamPublisher<Document> watch(ClientSession var1);

    public <TResult> ChangeStreamPublisher<TResult> watch(ClientSession var1, Class<TResult> var2);

    public ChangeStreamPublisher<Document> watch(ClientSession var1, List<? extends Bson> var2);

    public <TResult> ChangeStreamPublisher<TResult> watch(ClientSession var1, List<? extends Bson> var2, Class<TResult> var3);
}

