/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.DBObjectCodec;
import com.mongodb.MongoNamespace;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.Collation;
import com.mongodb.lang.Nullable;
import com.mongodb.operation.GroupOperation;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWrapper;
import org.bson.BsonJavaScript;
import org.bson.codecs.Decoder;
import org.bson.codecs.Encoder;

public class GroupCommand {
    private final String collectionName;
    private final DBObject keys;
    private final String keyf;
    private final DBObject condition;
    private final DBObject initial;
    private final String reduce;
    private final String finalize;
    private final Collation collation;

    public GroupCommand(DBCollection collection, DBObject keys, DBObject condition, DBObject initial, String reduce, @Nullable String finalize) {
        this(collection, keys, condition, initial, reduce, finalize, null);
    }

    public GroupCommand(DBCollection collection, DBObject keys, DBObject condition, DBObject initial, String reduce, @Nullable String finalize, @Nullable Collation collation) {
        Assertions.notNull((String)"collection", (Object)collection);
        this.collectionName = collection.getName();
        this.keys = keys;
        this.condition = condition;
        this.initial = initial;
        this.reduce = reduce;
        this.finalize = finalize;
        this.keyf = null;
        this.collation = collation;
    }

    public GroupCommand(DBCollection collection, String keyf, DBObject condition, DBObject initial, String reduce, String finalize) {
        this(collection, keyf, condition, initial, reduce, finalize, null);
    }

    public GroupCommand(DBCollection collection, String keyf, DBObject condition, DBObject initial, String reduce, @Nullable String finalize, @Nullable Collation collation) {
        Assertions.notNull((String)"collection", (Object)collection);
        this.collectionName = collection.getName();
        this.keyf = (String)Assertions.notNull((String)"keyf", (Object)keyf);
        this.condition = condition;
        this.initial = initial;
        this.reduce = reduce;
        this.finalize = finalize;
        this.keys = null;
        this.collation = collation;
    }

    public DBObject toDBObject() {
        BasicDBObject args = new BasicDBObject("ns", (Object)this.collectionName).append("cond", (Object)this.condition).append("$reduce", (Object)this.reduce).append("initial", (Object)this.initial);
        if (this.keys != null) {
            args.put("key", (Object)this.keys);
        }
        if (this.keyf != null) {
            args.put("$keyf", (Object)this.keyf);
        }
        if (this.finalize != null) {
            args.put("finalize", (Object)this.finalize);
        }
        return new BasicDBObject("group", (Object)args);
    }

    GroupOperation<DBObject> toOperation(MongoNamespace namespace, DBObjectCodec codec) {
        if (this.initial == null) {
            throw new IllegalArgumentException("Group command requires an initial document for the aggregate result");
        }
        if (this.reduce == null) {
            throw new IllegalArgumentException("Group command requires a reduce function for the aggregate result");
        }
        GroupOperation operation = new GroupOperation(namespace, new BsonJavaScript(this.reduce), (BsonDocument)new BsonDocumentWrapper((Object)this.initial, (Encoder)codec), (Decoder)codec);
        if (this.keys != null) {
            operation.key((BsonDocument)new BsonDocumentWrapper((Object)this.keys, (Encoder)codec));
        }
        if (this.keyf != null) {
            operation.keyFunction(new BsonJavaScript(this.keyf));
        }
        if (this.condition != null) {
            operation.filter((BsonDocument)new BsonDocumentWrapper((Object)this.condition, (Encoder)codec));
        }
        if (this.finalize != null) {
            operation.finalizeFunction(new BsonJavaScript(this.finalize));
        }
        operation.collation(this.collation);
        return operation;
    }
}

