/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.neo4j.ogm.config.ConfigurationSource;

public class ClasspathConfigurationSource
implements ConfigurationSource {
    private final Properties properties = new Properties();

    public ClasspathConfigurationSource(String propertiesFileName) {
        try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(propertiesFileName);){
            this.properties.load(is);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load properties file: " + propertiesFileName, e);
        }
    }

    @Override
    public Properties properties() {
        return this.properties;
    }
}

