/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.http.transaction;

import org.apache.http.Header;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicHeader;
import org.neo4j.ogm.drivers.http.driver.HttpDriver;
import org.neo4j.ogm.exception.TransactionException;
import org.neo4j.ogm.transaction.AbstractTransaction;
import org.neo4j.ogm.transaction.Transaction;
import org.neo4j.ogm.transaction.TransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpTransaction
extends AbstractTransaction {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpDriver.class);
    private final HttpDriver driver;
    private final String url;

    public HttpTransaction(TransactionManager transactionManager, HttpDriver driver, String url, Transaction.Type type) {
        super(transactionManager);
        this.driver = driver;
        this.url = url;
        this.type = type;
    }

    public void rollback() {
        try {
            if (this.transactionManager.canRollback()) {
                HttpDelete request = new HttpDelete(this.url);
                request.setHeader((Header)new BasicHeader("X-WRITE", this.driver.readOnly() ? "0" : "1"));
                this.driver.executeHttpRequest((HttpRequestBase)request);
            }
        }
        catch (Exception e) {
            LOGGER.warn(e.getLocalizedMessage());
        }
        finally {
            super.rollback();
        }
    }

    public void commit() {
        try {
            if (this.transactionManager.canCommit()) {
                HttpPost request = new HttpPost(this.url + "/commit");
                request.setHeader((Header)new BasicHeader("Content-Type", "application/json;charset=UTF-8"));
                request.setHeader((Header)new BasicHeader("X-WRITE", this.driver.readOnly() ? "0" : "1"));
                this.driver.executeHttpRequest((HttpRequestBase)request);
            }
        }
        catch (Exception e) {
            throw new TransactionException(e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            super.commit();
        }
    }

    public String url() {
        return this.url;
    }
}

