/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack.core.utils;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;

public class GenericUtil {
    private static final Map<Type, Map<String, Type>> genericInfoCached = new HashMap<Type, Map<String, Type>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Type> getGenericInfo(Type type) {
        Map<String, Type> tmp = genericInfoCached.get(type);
        if (tmp == null) {
            Type type2 = type;
            synchronized (type2) {
                tmp = genericInfoCached.get(type);
                if (tmp == null) {
                    tmp = GenericUtil.createTypeGenericMap(type);
                    genericInfoCached.put(type, tmp);
                }
            }
        }
        return tmp;
    }

    private static Map<String, Type> createTypeGenericMap(Type type) {
        ParameterizedType parameterizedType;
        HashMap<String, Type> typeMap = new HashMap<String, Type>();
        while (null != type && null != (parameterizedType = GenericUtil.toParameterizedType(type))) {
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            Class rawType = (Class)parameterizedType.getRawType();
            TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
            for (int i = 0; i < typeParameters.length; ++i) {
                Type value = typeArguments[i];
                if (value instanceof TypeVariable) continue;
                typeMap.put(typeParameters[i].getTypeName(), value);
            }
            type = rawType;
        }
        return typeMap;
    }

    public static ParameterizedType toParameterizedType(Type type) {
        ParameterizedType result = null;
        if (type instanceof ParameterizedType) {
            result = (ParameterizedType)type;
        } else if (type instanceof Class) {
            Type[] genericInterfaces;
            Class clazz = (Class)type;
            Type genericSuper = clazz.getGenericSuperclass();
            if ((null == genericSuper || Object.class.equals((Object)genericSuper)) && (genericInterfaces = clazz.getGenericInterfaces()) != null && genericInterfaces.length > 0) {
                genericSuper = genericInterfaces[0];
            }
            result = GenericUtil.toParameterizedType(genericSuper);
        }
        return result;
    }
}

