/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.route;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.noear.solon.core.util.PathMatcher;

public class PathRule
implements Predicate<String> {
    private List<PathMatcher> includeList = new ArrayList<PathMatcher>();
    private List<PathMatcher> excludeList = new ArrayList<PathMatcher>();

    public PathRule include(String ... patterns) {
        for (String p1 : patterns) {
            this.includeList.add(PathMatcher.get(p1));
        }
        return this;
    }

    public PathRule exclude(String ... patterns) {
        for (String p1 : patterns) {
            this.excludeList.add(PathMatcher.get(p1));
        }
        return this;
    }

    public boolean isEmpty() {
        return this.includeList.isEmpty() && this.excludeList.isEmpty();
    }

    @Override
    public boolean test(String path) {
        for (PathMatcher pa : this.excludeList) {
            if (!pa.matches(path)) continue;
            return false;
        }
        for (PathMatcher pa : this.includeList) {
            if (!pa.matches(path)) continue;
            return true;
        }
        return this.excludeList.size() > 0 && this.includeList.size() == 0;
    }
}

