/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.configuration;

import java.io.IOException;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.configuration.SpringDocConfiguration;
import org.springdoc.core.properties.SwaggerUiConfigProperties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

@Lazy(value=false)
@ConditionalOnExpression(value="${springdoc.api-docs.enabled:true} and ${springdoc.enable-native-support:false}")
@ConditionalOnWebApplication
@Configuration(proxyBeanMethods=false)
@ConditionalOnBean(value={SpringDocConfiguration.class})
public class SpringDocNativeConfiguration
implements InitializingBean {
    public static final String SPRINGDOC_CONFIG_PROPERTIES = "springdoc.config.properties";
    private static final String SPRINGDOC_SWAGGERUI_VERSION = "springdoc.swagger-ui.version";
    private final Optional<SwaggerUiConfigProperties> optionalSwaggerUiConfigProperties;

    public SpringDocNativeConfiguration(Optional<SwaggerUiConfigProperties> optionalSwaggerUiConfigProperties) {
        this.optionalSwaggerUiConfigProperties = optionalSwaggerUiConfigProperties;
    }

    public void afterPropertiesSet() {
        this.optionalSwaggerUiConfigProperties.ifPresent(swaggerUiConfigProperties -> {
            if (StringUtils.isEmpty((CharSequence)swaggerUiConfigProperties.getVersion())) {
                try {
                    ClassPathResource resource = new ClassPathResource("/springdoc.config.properties");
                    Properties props = PropertiesLoaderUtils.loadProperties((Resource)resource);
                    swaggerUiConfigProperties.setVersion(props.getProperty(SPRINGDOC_SWAGGERUI_VERSION));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }
}

