/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.support.micrometer;

import io.micrometer.observation.transport.ReceiverContext;
import org.springframework.amqp.core.Message;

public class RabbitMessageReceiverContext
extends ReceiverContext<Message> {
    private final String listenerId;
    private final Message message;

    public RabbitMessageReceiverContext(Message message, String listenerId) {
        super((carrier, key) -> (String)carrier.getMessageProperties().getHeader(key));
        this.setCarrier(message);
        this.message = message;
        this.listenerId = listenerId;
        this.setRemoteServiceName("RabbitMQ");
    }

    public String getListenerId() {
        return this.listenerId;
    }

    public String getSource() {
        return this.message.getMessageProperties().getConsumerQueue();
    }
}

