/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.config;

import io.micrometer.core.instrument.MeterRegistry;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.cloud.loadbalancer.stats.MicrometerStatsLoadBalancerLifecycle;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={MeterRegistry.class})
@ConditionalOnProperty(value={"spring.cloud.loadbalancer.stats.micrometer.enabled"}, havingValue="true")
public class LoadBalancerStatsAutoConfiguration {
    @Bean
    @ConditionalOnBean(value={MeterRegistry.class})
    public MicrometerStatsLoadBalancerLifecycle micrometerStatsLifecycle(MeterRegistry meterRegistry, ReactiveLoadBalancer.Factory<ServiceInstance> loadBalancerFactory) {
        return new MicrometerStatsLoadBalancerLifecycle(meterRegistry, loadBalancerFactory);
    }
}

