/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.webtestclient;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.http.HttpHeaders;
import org.springframework.restdocs.RestDocumentationContext;
import org.springframework.restdocs.RestDocumentationContextProvider;
import org.springframework.restdocs.config.RestDocumentationConfigurer;
import org.springframework.restdocs.webtestclient.WebTestClientOperationPreprocessorsConfigurer;
import org.springframework.restdocs.webtestclient.WebTestClientSnippetConfigurer;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import reactor.core.publisher.Mono;

public class WebTestClientRestDocumentationConfigurer
extends RestDocumentationConfigurer<WebTestClientSnippetConfigurer, WebTestClientOperationPreprocessorsConfigurer, WebTestClientRestDocumentationConfigurer>
implements ExchangeFilterFunction {
    private final WebTestClientSnippetConfigurer snippetConfigurer = new WebTestClientSnippetConfigurer(this);
    private static final Map<String, Map<String, Object>> configurations = new ConcurrentHashMap<String, Map<String, Object>>();
    private final WebTestClientOperationPreprocessorsConfigurer operationPreprocessorsConfigurer = new WebTestClientOperationPreprocessorsConfigurer(this);
    private final RestDocumentationContextProvider contextProvider;

    WebTestClientRestDocumentationConfigurer(RestDocumentationContextProvider contextProvider) {
        this.contextProvider = contextProvider;
    }

    public WebTestClientSnippetConfigurer snippets() {
        return this.snippetConfigurer;
    }

    public WebTestClientOperationPreprocessorsConfigurer operationPreprocessors() {
        return this.operationPreprocessorsConfigurer;
    }

    private Map<String, Object> createConfiguration() {
        RestDocumentationContext context = this.contextProvider.beforeOperation();
        HashMap<String, Object> configuration = new HashMap<String, Object>();
        configuration.put(RestDocumentationContext.class.getName(), context);
        this.apply(configuration, context);
        return configuration;
    }

    static Map<String, Object> retrieveConfiguration(HttpHeaders headers) {
        String requestId = headers.getFirst("WebTestClient-Request-Id");
        return configurations.remove(requestId);
    }

    public Mono<ClientResponse> filter(ClientRequest request, ExchangeFunction next) {
        String index = request.headers().getFirst("WebTestClient-Request-Id");
        configurations.put(index, this.createConfiguration());
        return next.exchange(this.applyUriDefaults(request));
    }

    private ClientRequest applyUriDefaults(ClientRequest request) {
        URI requestUri = request.url();
        if (!StringUtils.isEmpty((Object)requestUri.getHost())) {
            return request;
        }
        try {
            requestUri = new URI("http", requestUri.getUserInfo(), "localhost", 8080, requestUri.getPath(), requestUri.getQuery(), requestUri.getFragment());
            return ClientRequest.from((ClientRequest)request).url(requestUri).build();
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

