/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client;

import java.time.Clock;
import java.time.Duration;
import java.util.function.Function;
import org.springframework.lang.Nullable;
import org.springframework.security.oauth2.client.ClientAuthorizationException;
import org.springframework.security.oauth2.client.OAuth2AuthorizationContext;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.endpoint.DefaultTokenExchangeTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.TokenExchangeGrantRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2AuthorizationException;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.util.Assert;

public final class TokenExchangeOAuth2AuthorizedClientProvider
implements OAuth2AuthorizedClientProvider {
    private OAuth2AccessTokenResponseClient<TokenExchangeGrantRequest> accessTokenResponseClient = new DefaultTokenExchangeTokenResponseClient();
    private Function<OAuth2AuthorizationContext, OAuth2Token> subjectTokenResolver = this::resolveSubjectToken;
    private Function<OAuth2AuthorizationContext, OAuth2Token> actorTokenResolver = context -> null;
    private Duration clockSkew = Duration.ofSeconds(60L);
    private Clock clock = Clock.systemUTC();

    @Override
    @Nullable
    public OAuth2AuthorizedClient authorize(OAuth2AuthorizationContext context) {
        Assert.notNull((Object)context, (String)"context cannot be null");
        ClientRegistration clientRegistration = context.getClientRegistration();
        if (!AuthorizationGrantType.TOKEN_EXCHANGE.equals((Object)clientRegistration.getAuthorizationGrantType())) {
            return null;
        }
        OAuth2AuthorizedClient authorizedClient = context.getAuthorizedClient();
        if (authorizedClient != null && !this.hasTokenExpired((OAuth2Token)authorizedClient.getAccessToken())) {
            return null;
        }
        OAuth2Token subjectToken = this.subjectTokenResolver.apply(context);
        if (subjectToken == null) {
            return null;
        }
        OAuth2Token actorToken = this.actorTokenResolver.apply(context);
        TokenExchangeGrantRequest grantRequest = new TokenExchangeGrantRequest(clientRegistration, subjectToken, actorToken);
        OAuth2AccessTokenResponse tokenResponse = this.getTokenResponse(clientRegistration, grantRequest);
        return new OAuth2AuthorizedClient(clientRegistration, context.getPrincipal().getName(), tokenResponse.getAccessToken());
    }

    private OAuth2Token resolveSubjectToken(OAuth2AuthorizationContext context) {
        Object object = context.getPrincipal().getPrincipal();
        if (object instanceof OAuth2Token) {
            OAuth2Token accessToken = (OAuth2Token)object;
            return accessToken;
        }
        return null;
    }

    private OAuth2AccessTokenResponse getTokenResponse(ClientRegistration clientRegistration, TokenExchangeGrantRequest tokenExchangeGrantRequest) {
        try {
            return this.accessTokenResponseClient.getTokenResponse(tokenExchangeGrantRequest);
        }
        catch (OAuth2AuthorizationException ex) {
            throw new ClientAuthorizationException(ex.getError(), clientRegistration.getRegistrationId(), ex);
        }
    }

    private boolean hasTokenExpired(OAuth2Token token) {
        return this.clock.instant().isAfter(token.getExpiresAt().minus(this.clockSkew));
    }

    public void setAccessTokenResponseClient(OAuth2AccessTokenResponseClient<TokenExchangeGrantRequest> accessTokenResponseClient) {
        Assert.notNull(accessTokenResponseClient, (String)"accessTokenResponseClient cannot be null");
        this.accessTokenResponseClient = accessTokenResponseClient;
    }

    public void setSubjectTokenResolver(Function<OAuth2AuthorizationContext, OAuth2Token> subjectTokenResolver) {
        Assert.notNull(subjectTokenResolver, (String)"subjectTokenResolver cannot be null");
        this.subjectTokenResolver = subjectTokenResolver;
    }

    public void setActorTokenResolver(Function<OAuth2AuthorizationContext, OAuth2Token> actorTokenResolver) {
        Assert.notNull(actorTokenResolver, (String)"actorTokenResolver cannot be null");
        this.actorTokenResolver = actorTokenResolver;
    }

    public void setClockSkew(Duration clockSkew) {
        Assert.notNull((Object)clockSkew, (String)"clockSkew cannot be null");
        Assert.isTrue((clockSkew.getSeconds() >= 0L ? 1 : 0) != 0, (String)"clockSkew must be >= 0");
        this.clockSkew = clockSkew;
    }

    public void setClock(Clock clock) {
        Assert.notNull((Object)clock, (String)"clock cannot be null");
        this.clock = clock;
    }
}

