/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.resource.introspection;

import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.TokenIntrospectionResponse;
import com.nimbusds.oauth2.sdk.TokenIntrospectionSuccessResponse;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.Audience;
import java.net.URI;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.support.BasicAuthenticationInterceptor;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.server.resource.introspection.BadOpaqueTokenException;
import org.springframework.security.oauth2.server.resource.introspection.OAuth2IntrospectionAuthenticatedPrincipal;
import org.springframework.security.oauth2.server.resource.introspection.OAuth2IntrospectionException;
import org.springframework.security.oauth2.server.resource.introspection.OpaqueTokenIntrospector;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public class NimbusOpaqueTokenIntrospector
implements OpaqueTokenIntrospector {
    private static final String AUTHORITY_PREFIX = "SCOPE_";
    private final Log logger = LogFactory.getLog(this.getClass());
    private final RestOperations restOperations;
    private Converter<String, RequestEntity<?>> requestEntityConverter;

    public NimbusOpaqueTokenIntrospector(String introspectionUri, String clientId, String clientSecret) {
        Assert.notNull((Object)introspectionUri, (String)"introspectionUri cannot be null");
        Assert.notNull((Object)clientId, (String)"clientId cannot be null");
        Assert.notNull((Object)clientSecret, (String)"clientSecret cannot be null");
        this.requestEntityConverter = this.defaultRequestEntityConverter(URI.create(introspectionUri));
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.getInterceptors().add(new BasicAuthenticationInterceptor(clientId, clientSecret));
        this.restOperations = restTemplate;
    }

    public NimbusOpaqueTokenIntrospector(String introspectionUri, RestOperations restOperations) {
        Assert.notNull((Object)introspectionUri, (String)"introspectionUri cannot be null");
        Assert.notNull((Object)restOperations, (String)"restOperations cannot be null");
        this.requestEntityConverter = this.defaultRequestEntityConverter(URI.create(introspectionUri));
        this.restOperations = restOperations;
    }

    private Converter<String, RequestEntity<?>> defaultRequestEntityConverter(URI introspectionUri) {
        return token -> {
            HttpHeaders headers = this.requestHeaders();
            MultiValueMap<String, String> body = this.requestBody((String)token);
            return new RequestEntity(body, (MultiValueMap)headers, HttpMethod.POST, introspectionUri);
        };
    }

    private HttpHeaders requestHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        return headers;
    }

    private MultiValueMap<String, String> requestBody(String token) {
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"token", (Object)token);
        return body;
    }

    @Override
    public OAuth2AuthenticatedPrincipal introspect(String token) {
        RequestEntity requestEntity = (RequestEntity)this.requestEntityConverter.convert((Object)token);
        if (requestEntity == null) {
            throw new OAuth2IntrospectionException("requestEntityConverter returned a null entity");
        }
        ResponseEntity<String> responseEntity = this.makeRequest(requestEntity);
        HTTPResponse httpResponse = this.adaptToNimbusResponse(responseEntity);
        TokenIntrospectionResponse introspectionResponse = this.parseNimbusResponse(httpResponse);
        TokenIntrospectionSuccessResponse introspectionSuccessResponse = this.castToNimbusSuccess(introspectionResponse);
        if (!introspectionSuccessResponse.isActive()) {
            this.logger.trace((Object)"Did not validate token since it is inactive");
            throw new BadOpaqueTokenException("Provided token isn't active");
        }
        return this.convertClaimsSet(introspectionSuccessResponse);
    }

    public void setRequestEntityConverter(Converter<String, RequestEntity<?>> requestEntityConverter) {
        Assert.notNull(requestEntityConverter, (String)"requestEntityConverter cannot be null");
        this.requestEntityConverter = requestEntityConverter;
    }

    private ResponseEntity<String> makeRequest(RequestEntity<?> requestEntity) {
        try {
            return this.restOperations.exchange(requestEntity, String.class);
        }
        catch (Exception ex) {
            throw new OAuth2IntrospectionException(ex.getMessage(), ex);
        }
    }

    private HTTPResponse adaptToNimbusResponse(ResponseEntity<String> responseEntity) {
        MediaType contentType = responseEntity.getHeaders().getContentType();
        if (contentType == null) {
            this.logger.trace((Object)"Did not receive Content-Type from introspection endpoint in response");
            throw new OAuth2IntrospectionException("Introspection endpoint response was invalid, as no Content-Type header was provided");
        }
        if (!contentType.isCompatibleWith(MediaType.APPLICATION_JSON)) {
            this.logger.trace((Object)"Did not receive JSON-compatible Content-Type from introspection endpoint in response");
            throw new OAuth2IntrospectionException("Introspection endpoint response was invalid, as content type '" + String.valueOf(contentType) + "' is not compatible with JSON");
        }
        HTTPResponse response = new HTTPResponse(responseEntity.getStatusCode().value());
        response.setHeader("Content-Type", new String[]{contentType.toString()});
        response.setContent((String)responseEntity.getBody());
        if (response.getStatusCode() != 200) {
            this.logger.trace((Object)"Introspection endpoint returned non-OK status code");
            throw new OAuth2IntrospectionException("Introspection endpoint responded with HTTP status code " + response.getStatusCode());
        }
        return response;
    }

    private TokenIntrospectionResponse parseNimbusResponse(HTTPResponse response) {
        try {
            return TokenIntrospectionResponse.parse((HTTPResponse)response);
        }
        catch (Exception ex) {
            throw new OAuth2IntrospectionException(ex.getMessage(), ex);
        }
    }

    private TokenIntrospectionSuccessResponse castToNimbusSuccess(TokenIntrospectionResponse introspectionResponse) {
        if (!introspectionResponse.indicatesSuccess()) {
            ErrorObject errorObject = introspectionResponse.toErrorResponse().getErrorObject();
            String message = "Token introspection failed with response " + errorObject.toJSONObject().toJSONString();
            this.logger.trace((Object)message);
            throw new OAuth2IntrospectionException(message);
        }
        return (TokenIntrospectionSuccessResponse)introspectionResponse;
    }

    private OAuth2AuthenticatedPrincipal convertClaimsSet(TokenIntrospectionSuccessResponse response) {
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        JSONObject claims = response.toJSONObject();
        if (response.getAudience() != null) {
            ArrayList<String> audiences = new ArrayList<String>();
            for (Audience audience : response.getAudience()) {
                audiences.add(audience.getValue());
            }
            claims.put("aud", Collections.unmodifiableList(audiences));
        }
        if (response.getClientID() != null) {
            claims.put("client_id", response.getClientID().getValue());
        }
        if (response.getExpirationTime() != null) {
            Instant exp = response.getExpirationTime().toInstant();
            claims.put("exp", exp);
        }
        if (response.getIssueTime() != null) {
            Instant iat = response.getIssueTime().toInstant();
            claims.put("iat", iat);
        }
        if (response.getIssuer() != null) {
            claims.put("iss", response.getIssuer().getValue());
        }
        if (response.getNotBeforeTime() != null) {
            claims.put("nbf", response.getNotBeforeTime().toInstant());
        }
        if (response.getScope() != null) {
            List<String> scopes = Collections.unmodifiableList(response.getScope().toStringList());
            claims.put("scope", scopes);
            for (String scope : scopes) {
                authorities.add((GrantedAuthority)new SimpleGrantedAuthority(AUTHORITY_PREFIX + scope));
            }
        }
        return new OAuth2IntrospectionAuthenticatedPrincipal((Map<String, Object>)claims, authorities);
    }
}

