/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.rsocket.service;

import java.util.Collection;
import org.springframework.core.MethodParameter;
import org.springframework.lang.Nullable;
import org.springframework.messaging.handler.annotation.DestinationVariable;
import org.springframework.messaging.rsocket.service.RSocketRequestValues;
import org.springframework.messaging.rsocket.service.RSocketServiceArgumentResolver;

public class DestinationVariableArgumentResolver
implements RSocketServiceArgumentResolver {
    @Override
    public boolean resolve(@Nullable Object argument, MethodParameter parameter, RSocketRequestValues.Builder requestValues) {
        DestinationVariable annot = (DestinationVariable)parameter.getParameterAnnotation(DestinationVariable.class);
        if (annot == null) {
            return false;
        }
        if (argument != null) {
            if (argument instanceof Collection) {
                ((Collection)argument).forEach(requestValues::addRouteVariable);
                return true;
            }
            if (argument.getClass().isArray()) {
                for (Object variable : (Object[])argument) {
                    requestValues.addRouteVariable(variable);
                }
                return true;
            }
            requestValues.addRouteVariable(argument);
        }
        return true;
    }
}

