/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.test.context.DynamicPropertyRegistry;
import org.springframework.util.Assert;
import org.springframework.util.function.SupplierUtils;

class DynamicValuesPropertySource
extends MapPropertySource {
    static final String PROPERTY_SOURCE_NAME = "Dynamic Test Properties";
    final DynamicPropertyRegistry dynamicPropertyRegistry = (name, valueSupplier) -> {
        Assert.hasText((String)name, (String)"'name' must not be null or blank");
        Assert.notNull((Object)valueSupplier, (String)"'valueSupplier' must not be null");
        valueSuppliers.put(name, valueSupplier);
    };

    DynamicValuesPropertySource() {
        this(Collections.synchronizedMap(new LinkedHashMap()));
    }

    DynamicValuesPropertySource(Map<String, Supplier<Object>> valueSuppliers) {
        super(PROPERTY_SOURCE_NAME, Collections.unmodifiableMap(valueSuppliers));
    }

    public @Nullable Object getProperty(String name) {
        return SupplierUtils.resolve((Object)super.getProperty(name));
    }

    static DynamicValuesPropertySource getOrCreate(ConfigurableEnvironment environment) {
        MutablePropertySources propertySources = environment.getPropertySources();
        PropertySource propertySource = propertySources.get(PROPERTY_SOURCE_NAME);
        if (propertySource instanceof DynamicValuesPropertySource) {
            DynamicValuesPropertySource dynamicValuesPropertySource = (DynamicValuesPropertySource)propertySource;
            return dynamicValuesPropertySource;
        }
        if (propertySource == null) {
            DynamicValuesPropertySource dynamicValuesPropertySource = new DynamicValuesPropertySource();
            propertySources.addFirst((PropertySource)dynamicValuesPropertySource);
            return dynamicValuesPropertySource;
        }
        throw new IllegalStateException("PropertySource with name '%s' must be a DynamicValuesPropertySource".formatted(PROPERTY_SOURCE_NAME));
    }
}

