/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.client;

import java.io.IOException;
import java.net.HttpCookie;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseCookie;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.MultiValueMapAdapter;
import org.springframework.web.client.RestClient;

public class ExchangeResult {
    private static final Pattern SAME_SITE_PATTERN = Pattern.compile("(?i).*SameSite=(Strict|Lax|None).*");
    private static final Pattern PARTITIONED_PATTERN = Pattern.compile("(?i).*;\\s*Partitioned(\\s*;.*|\\s*)$");
    private static final Log logger = LogFactory.getLog(ExchangeResult.class);
    private final HttpRequest request;
    private final RestClient.RequestHeadersSpec.ConvertibleClientHttpResponse clientResponse;
    private final @Nullable String uriTemplate;
    private boolean diagnosticsLogged;

    ExchangeResult(HttpRequest request, RestClient.RequestHeadersSpec.ConvertibleClientHttpResponse response, @Nullable String uriTemplate) {
        Assert.notNull((Object)request, (String)"HttpRequest must not be null");
        Assert.notNull((Object)response, (String)"ClientHttpResponse must not be null");
        this.request = request;
        this.clientResponse = response;
        this.uriTemplate = uriTemplate;
    }

    ExchangeResult(ExchangeResult result) {
        this(result.request, result.clientResponse, result.uriTemplate);
        this.diagnosticsLogged = result.diagnosticsLogged;
    }

    public HttpMethod getMethod() {
        return this.request.getMethod();
    }

    public URI getUrl() {
        return this.request.getURI();
    }

    public @Nullable String getUriTemplate() {
        return this.uriTemplate;
    }

    public HttpHeaders getRequestHeaders() {
        return this.request.getHeaders();
    }

    public HttpStatusCode getStatus() {
        try {
            return this.clientResponse.getStatusCode();
        }
        catch (IOException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public HttpHeaders getResponseHeaders() {
        return this.clientResponse.getHeaders();
    }

    public MultiValueMap<String, ResponseCookie> getResponseCookies() {
        return (MultiValueMap)Optional.ofNullable(this.clientResponse.getHeaders().get("Set-Cookie")).orElse(List.of()).stream().flatMap(header -> {
            Matcher matcher = SAME_SITE_PATTERN.matcher((CharSequence)header);
            String sameSite = matcher.matches() ? matcher.group(1) : null;
            boolean partitioned = PARTITIONED_PATTERN.matcher((CharSequence)header).matches();
            return HttpCookie.parse(header).stream().map(cookie -> ExchangeResult.toResponseCookie(cookie, sameSite, partitioned));
        }).collect(LinkedMultiValueMap::new, (cookies, cookie) -> cookies.add((Object)cookie.getName(), cookie), MultiValueMapAdapter::addAll);
    }

    private static ResponseCookie toResponseCookie(HttpCookie cookie, @Nullable String sameSite, boolean partitioned) {
        return ResponseCookie.from((String)cookie.getName(), (String)cookie.getValue()).domain(cookie.getDomain()).httpOnly(cookie.isHttpOnly()).maxAge(cookie.getMaxAge()).path(cookie.getPath()).secure(cookie.getSecure()).sameSite(sameSite).partitioned(partitioned).build();
    }

    public <T> @Nullable T getBody(Class<T> bodyType) {
        return (T)this.clientResponse.bodyTo(bodyType);
    }

    public <T> @Nullable T getBody(ParameterizedTypeReference<T> bodyType) {
        return (T)this.clientResponse.bodyTo(bodyType);
    }

    public void assertWithDiagnostics(Runnable assertion) {
        try {
            assertion.run();
        }
        catch (AssertionError ex) {
            if (!this.diagnosticsLogged && logger.isErrorEnabled()) {
                this.diagnosticsLogged = true;
                logger.error((Object)("Request details for assertion failure:\n" + String.valueOf(this)));
            }
            throw ex;
        }
    }

    public String toString() {
        return "\n> " + String.valueOf(this.getMethod()) + " " + String.valueOf(this.getUrl()) + "\n> " + this.formatHeaders(this.getRequestHeaders(), "\n> ") + "\n\n< " + this.formatStatus(this.getStatus()) + "\n< " + this.formatHeaders(this.getResponseHeaders(), "\n< ") + "\n";
    }

    private String formatStatus(HttpStatusCode statusCode) {
        Object result = statusCode.toString();
        if (statusCode instanceof HttpStatus) {
            HttpStatus status = (HttpStatus)statusCode;
            result = (String)result + " " + status.getReasonPhrase();
        }
        return result;
    }

    private String formatHeaders(HttpHeaders headers, String delimiter) {
        return headers.headerSet().stream().map(entry -> (String)entry.getKey() + ": " + String.valueOf(entry.getValue())).collect(Collectors.joining(delimiter));
    }
}

